import pandas as pd
from sklearn.preprocessing import LabelEncoder    
import pickle
from decision_company import read_csv_file, df_copy, encoder_instance, encode_column

# Load the dataset  
credit_customers = read_csv_file("credit_customers.csv")  
  
# Create a copy of the stable_employment DataFrame  
stable_employment_encoded = df_copy(stable_employment)  
  
# Initialize the label encoder  
encoder = encoder_instance()  
  
# Convert non-numeric columns to numeric values using label encoding 
for column in stable_employment_encoded.columns:    
    if stable_employment_encoded[column].dtype == 'object':    
        stable_employment_encoded[column] = encode_column(encoder, stable_employment_encoded[column])   
 
print(f"stable_employment_encoded: {stable_employment_encoded}")  
pickle.dump(stable_employment_encoded, open("./ref_result/stable_employment_encoded.pkl","wb"))

  